/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import mfto.schema.Documento;
import mfto.schema.DocumentoType;
import mfto.schema.ObjectFactory;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.MaritimoANUv10;

public class MFTOv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public MFTOv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        block21: {
            try {
                ObjectFactory objFactory = new ObjectFactory();
                Documento documento = objFactory.createDocumento();
                documentWrapper dw = new documentWrapper(new File(this.file));
                if (!dw.getAttribute("tipo-accion").equals("N")) {
                    String xml;
                    block23: {
                        if (dw.getDocType().equals("MFTO")) {
                            documento.setTipo(dw.getDocType());
                        }
                        if (dw.getVersion().equals("1.0")) {
                            documento.setVersion(dw.getVersion());
                        }
                        if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                            documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
                        }
                        if (dw.existAttribute("fecha-aceptacion-mfto") && !dw.getAttribute("fecha-aceptacion-mfto").equals("")) {
                            documento.setFechaAceptacionMfto(dw.getAttribute("fecha-aceptacion-mfto").trim());
                        }
                        if (dw.existAttribute("numero-referencia-original") && !dw.getAttribute("numero-referencia-original").equals("")) {
                            documento.setNumeroReferenciaOriginal(dw.getAttribute("numero-referencia-original").trim());
                        }
                        if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                            documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
                        }
                        if (dw.existAttribute("tipo-manifiesto") && !dw.getAttribute("tipo-manifiesto").equals("")) {
                            documento.setTipoManifiesto(dw.getAttribute("tipo-manifiesto").trim());
                        }
                        if (dw.existAttribute("cond-carga") && !dw.getAttribute("cond-carga").equals("")) {
                            documento.setCondCarga(dw.getAttribute("cond-carga").trim());
                        }
                        if (dw.existAttribute("sitio-atraque") && !dw.getAttribute("sitio-atraque").equals("")) {
                            documento.setSitioAtraque(dw.getAttribute("sitio-atraque").trim());
                        }
                        this.cargaOpTransporte(documento, dw);
                        this.cargaFechas(documento, dw);
                        this.cargaLocaciones(documento, dw);
                        this.cargaParticipantes(documento, dw);
                        this.cargaReferencias(documento, dw);
                        this.cargaObservaciones(documento, dw);
                        JAXBContext jc = JAXBContext.newInstance("mfto.schema");
                        Validator v = jc.createValidator();
                        this.valid = v.validateRoot(documento);
                        if (!this.valid) break block21;
                        Marshaller m = jc.createMarshaller();
                        m.setProperty("jaxb.encoding", "ISO-8859-1");
                        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                        if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                            new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                        }
                        xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                        FileOutputStream fileOut = new FileOutputStream(xml);
                        try {
                            try {
                                m.marshal((Object)documento, fileOut);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                fileOut.flush();
                                fileOut.close();
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            fileOut.flush();
                            fileOut.close();
                            throw throwable;
                        }
                        fileOut.flush();
                        fileOut.close();
                    }
                    if (new File(xml).exists()) {
                        Util.setNuevoTag("itinerary", "itinerario", xml);
                    }
                    break block21;
                }
                this.valid = new MaritimoANUv10(this.file, this.doc).isValid();
            }
            catch (Exception e) {
                if (!this.valid) {
                    Start.pe("\t=> [" + this.doc + "]: MFTO con Estructura Invalida.-");
                    if (e.toString().indexOf(".Abort") != -1) {
                        String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                        Start.pe("\t+ " + msgError);
                    } else {
                        Start.pe("\t+ " + e.toString());
                    }
                    Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
                }
                Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
                this.valid = false;
            }
        }
    }

    private void cargaOpTransporte(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("OpTransporte")) {
                AttrContainer atc2;
                DocumentoType.OpTransporteType OpTrTp = objFactory.createDocumentoTypeOpTransporteType();
                DocumentoType.OpTransporteType.OptransporteType opTrTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteType();
                DocumentoType.OpTransporteType.OptransporteType.ItinerarioType ItTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteTypeItinerarioType();
                AttrContainer atc = dw.getContainer("OpTransporte");
                Enumeration enm = atc.getItems();
                ContainerItem ci = (ContainerItem)enm.nextElement();
                Properties prop = ci.getAttributes();
                if (prop.containsKey("bandera-nave") && !prop.get("bandera-nave").equals("")) {
                    opTrTp.setBanderaNave(String.valueOf(prop.get("bandera-nave")).trim());
                }
                if (prop.containsKey("nombre-nave") && !prop.get("nombre-nave").equals("")) {
                    opTrTp.setNombreNave(String.valueOf(prop.get("nombre-nave")).trim());
                }
                if (prop.containsKey("registro-nave") && !prop.get("registro-nave").equals("")) {
                    opTrTp.setRegistroNave(String.valueOf(prop.get("registro-nave")).trim());
                }
                if (prop.containsKey("servicio") && !prop.get("servicio").equals("")) {
                    opTrTp.setServicio(String.valueOf(prop.get("servicio")).trim());
                }
                if (prop.containsKey("viaje") && !prop.get("viaje").equals("")) {
                    opTrTp.setViaje(String.valueOf(prop.get("viaje")).trim());
                }
                if ((atc2 = ci.getContainer("Itinerario")) != null) {
                    Enumeration enm2 = atc2.getItems();
                    while (enm2.hasMoreElements()) {
                        ContainerItem ci2 = (ContainerItem)enm2.nextElement();
                        Properties prop2 = ci2.getAttributes();
                        DocumentoType.OpTransporteType.OptransporteType.ItinerarioType.ItineraryType itTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteTypeItinerarioTypeItineraryType();
                        if (prop2.containsKey("descripcion") && !prop2.get("descripcion").equals("")) {
                            itTp.setDescripcion(String.valueOf(prop2.get("descripcion")).trim());
                        }
                        if (prop2.containsKey("fecha-arribo") && !prop2.get("fecha-arribo").equals("")) {
                            itTp.setFechaArribo(String.valueOf(prop2.get("fecha-arribo")).trim());
                        }
                        if (prop2.containsKey("fecha-termino") && !prop2.get("fecha-termino").equals("")) {
                            itTp.setFechaTermino(String.valueOf(prop2.get("fecha-termino")).trim());
                        }
                        if (prop2.containsKey("lugar") && !prop2.get("lugar").equals("")) {
                            itTp.setLugar(String.valueOf(prop2.get("lugar")).trim());
                        }
                        ItTp.getItinerary().add(itTp);
                    }
                    opTrTp.setItinerario(ItTp);
                }
                OpTrTp.setOptransporte(opTrTp);
                documento.setOpTransporte(OpTrTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType FcTp = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fcTp = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fcTp.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fcTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    FcTp.getFecha().add(fcTp);
                }
                documento.setFechas(FcTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType LocTp = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locTp = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locTp.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        locTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    LocTp.getLocacion().add(locTp);
                }
                documento.setLocaciones(LocTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipantes(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("codigo-pais") && !prop.get("codigo-pais").equals("")) {
                        partTp.setCodigoPais(String.valueOf(prop.get("codigo-pais")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        partTp.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        partTp.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        partTp.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    PartTp.getParticipacion().add(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaReferencias(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Referencias")) {
                DocumentoType.ReferenciasType RefTp = objFactory.createDocumentoTypeReferenciasType();
                DocumentoType.ReferenciasType.ReferenciaType refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                AttrContainer atc = dw.getContainer("Referencias");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                    if (prop.containsKey("tipo-referencia") && !prop.get("tipo-referencia").equals("")) {
                        refTp.setTipoReferencia(String.valueOf(prop.get("tipo-referencia")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        refTp.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        refTp.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("valor-id-emisor") && !prop.get("valor-id-emisor").equals("")) {
                        refTp.setValorIdEmisor(String.valueOf(prop.get("valor-id-emisor")).trim());
                    }
                    if (prop.containsKey("tipo-id-emisor") && !prop.get("tipo-id-emisor").equals("")) {
                        refTp.setTipoIdEmisor(String.valueOf(prop.get("tipo-id-emisor")).trim());
                    }
                    if (prop.containsKey("nac-id-emisor") && !prop.get("nac-id-emisor").equals("")) {
                        refTp.setNacIdEmisor(String.valueOf(prop.get("nac-id-emisor")).trim());
                    }
                    if (prop.containsKey("emisor") && !prop.get("emisor").equals("")) {
                        refTp.setEmisor(String.valueOf(prop.get("emisor")).trim());
                    }
                    if (prop.containsKey("tipo-documento") && !prop.get("tipo-documento").equals("")) {
                        refTp.setTipoDocumento(String.valueOf(prop.get("tipo-documento")).trim());
                    }
                    RefTp.getReferencia().add(refTp);
                }
                documento.setReferencias(RefTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Observaciones")) {
                DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

