/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import sms.soap.Config;
import sms.util.Util;

public class TipoDocumento {
    private Config conf;
    private String codigo;
    private String version;
    private String descripcion;
    private boolean activo;
    private AttrContainer digitadores;
    private AttrContainer modificadores;
    private AttrContainer aclaradores;
    private AttrContainer anuladores;
    private AttrContainer visadores;
    private ContainerItem item;
    private Vector atributosExtra = null;

    public TipoDocumento(ContainerItem item) {
        this.item = item;
        this.codigo = item.getAttribute("codigo");
        this.version = item.getAttribute("version");
        this.descripcion = item.getAttribute("descripcion");
        this.activo = item.getAttribute("activo").equals("si");
        this.digitadores = item.getContainer("digitadores-autorizados");
        this.modificadores = item.getContainer("modificadores-autorizados");
        this.aclaradores = item.getContainer("aclaradores-autorizados");
        this.anuladores = item.getContainer("anuladores-autorizados");
        this.visadores = item.getContainer("visadores-autorizados");
        AttrContainer cntExtras = item.getContainer("atributos-extra");
        if (cntExtras != null) {
            this.atributosExtra = new Vector();
            int i = 0;
            while (i < cntExtras.size()) {
                this.atributosExtra.add(cntExtras.getItem(i).getAttribute("nombre-atributo"));
                ++i;
            }
        }
    }

    public TipoDocumento(Config conf, ContainerItem item) {
        this.conf = conf;
        this.item = item;
        this.codigo = item.getAttribute("codigo");
        this.version = item.getAttribute("version");
        this.descripcion = item.getAttribute("descripcion");
        this.activo = item.getAttribute("activo").equals("si");
        this.digitadores = item.getContainer("digitadores-autorizados");
        this.modificadores = item.getContainer("modificadores-autorizados");
        this.aclaradores = item.getContainer("aclaradores-autorizados");
        this.anuladores = item.getContainer("anuladores-autorizados");
        this.visadores = item.getContainer("visadores-autorizados");
        AttrContainer cntExtras = item.getContainer("atributos-extra");
        if (cntExtras != null) {
            this.atributosExtra = new Vector();
            int i = 0;
            while (i < cntExtras.size()) {
                this.atributosExtra.add(cntExtras.getItem(i).getAttribute("nombre-atributo"));
                ++i;
            }
        }
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getVersion() {
        return this.version;
    }

    public long siguienteNumero(boolean actualiza) throws Exception {
        Hashtable numeros;
        String nombreArchivo = String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "servidor-numeros.xml";
        File f = new File(nombreArchivo);
        if (f.exists()) {
            FileInputStream istream = new FileInputStream(f);
            ObjectInputStream p = new ObjectInputStream(istream);
            numeros = (Hashtable)p.readObject();
            istream.close();
        } else {
            numeros = new Hashtable();
        }
        Long n = (Long)numeros.get(String.valueOf(this.conf.getNombreServidor()) + "-" + this.codigo);
        if (n == null) {
            n = new Long(1L);
        } else {
            numeros.remove(String.valueOf(this.conf.getNombreServidor()) + "-" + this.codigo);
            n = new Long(n + 1L);
        }
        if (actualiza) {
            numeros.put(String.valueOf(this.conf.getNombreServidor()) + "-" + this.codigo, n);
            FileOutputStream ostream = new FileOutputStream(f);
            ObjectOutputStream po = new ObjectOutputStream(ostream);
            po.writeObject(numeros);
            po.flush();
            ostream.close();
        }
        return n;
    }

    public long siguienteNumero() throws Exception {
        return this.siguienteNumero(true);
    }

    public Vector getAtributosExtra() {
        return this.atributosExtra;
    }
}

