/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.ant;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.Task;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final Task task;
    boolean hadError = false;

    public ErrorHandlerImpl(Task t) {
        this.task = t;
    }

    public void error(SAXParseException e) throws SAXException {
        this.print(e, 0);
        this.hadError = true;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.print(e, 0);
        this.hadError = true;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.print(e, 1);
    }

    private void print(SAXParseException e, int msgLevel) {
        this.task.log(e.getMessage(), msgLevel);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        this.task.log(sw.toString(), 3);
    }
}

